/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2010 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
package com.genesyslab.samples.interceptor;

/**
 * This class is used to implement the behavior that must be executed when server stops.
 * In this sample the behavior consists in calling a primitive of the AuditFileManager that closes 
 * the plain text file after writing a end timestamp in it.
 * This interceptor has no property.
 * In configuration file interceptor.xml it is configured in this XML fragment:
 *      <interceptor name="SERVER_STOP" implementation-class="com.genesyslab.samples.interceptor.StopServer" method="execute">
 *      </interceptor>
 */
public class StopServer {

    /**
     * This method is referenced as attribute "method" in corresponding interceptor.xml tag.
     * It is called automatically by the framework after all the "in" properties have been set
     * thanks to the set method declared above.
     */
    public void execute() {
        AuditFileManager mgr = AuditFileManager.getInstance();
        mgr.append("Server is stopping");
        mgr.close();
    }
}
